;------------------------------------------------------------------------
; Sega ST-V
; SSF v0.12 Beta R1
; by djvj
; 1.0
;
; Info
; romExtension should be zip
; Extract the stv110.bin bios into the BIOS folder. Run SSF.exe and goto Option-Option and point ST-V BIOS to this file.
; For correct fullscreen operation, make sure these settings are checked in Option-Option-Screen Enforce Aspect Ratio (Fullscreen) and Full Size
; To skip seeing the BIOS screen at launch everytime, goto Option-Option-Program4, and check No BIOS
; If you are getting clipping, turn on VSynchWaitFullscreen, or set it to 1 in the ini
;
; On first launch, press Alt+Enter to enter fullscreen mode. Then exit the emu. Next time you launch it, it will be fullscreen.
; If it seems like it's taking a long time to load, it probably is. You are going to stare at the black screen while SSF is decoding the roms. If you want to see it in action, comment out the GUI lines.
;------------------------------------------------------------------------

; This gets rid of the emu window that pops up on launch
Gui +AlwaysOnTop -Caption +ToolWindow
Gui Color, 000000
Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%, HSHIDE

Run, %executable%, %emuPath%
Send, {SHIFTDOWN} ; this tells SSF we want to boot in ST-V mode
WinWait, Select ROM file
IfWinNotActive, Select ROM file, , WinActivate, Select ROM file
WinWaitActive, Select ROM file
Send, {SHIFTUP}
Sleep, 100
clipboard=
clipboard=%romPath%%romName%%romExtension%
ClipWait
Sleep, 100 ; increase this if your clipboard is not pasting in
Send, ^v
Sleep,100
Send, {ENTER}
Process, WaitClose, %executable%

ExitApp

CloseProcess
return